/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef __MX_CPU__
#define __MX_CPU__

/***************************
 * x86-specific ASM checks *
 ***************************/
#if defined __GNUC__ && (MX_CPU_x86 || MX_CPU_x86_64)

#if (!defined MX_KERNEL) && (MX_ENABLE_SSE2 || MX_CPU_x86_64)
#define MX_COPY_WITH_SSE2 1
#if __GNUC__ >= 3 && defined __SSE2__
#define MX_ASM_XMM_DEP ,"xmm0", "xmm1", "xmm2", "xmm3"
#else
#define MX_ASM_XMM_DEP
#endif
#endif
#if MX_CPU_x86_64
#define RBX "rbx"
#else
#define RBX "ebx"
#endif

static inline int mx__cpu_has_sse2(void)
{
  uint32_t eax,ecx,edx;
  __asm__("push %%"RBX";cpuid;pop %%"RBX : "=a" (eax), "=c" (ecx), "=d" (edx) : "0" (1));
  return (edx & (1 << 26)) != 0;
}

static inline int mx__cpu_is_intel(void)
{
  uint32_t eax, ebx, ecx, edx;
  uint64_t rbx_save;
  __asm__("mov %%"RBX", %4; cpuid; mov %%ebx,%3; mov %4,%%"RBX :
	  "=a" (eax), "=c" (ecx), "=d" (edx), "=m" (ebx), "=m" (rbx_save) : "0" (0));
  /* ebx edx ecx means "GenuineIntel" */
  return ebx == 0x756e6547 && edx == 0x49656e69 && ecx == 0x6c65746e;
}

#endif

/***************************
 * ppc-specific ASM checks *
 ***************************/
#if defined __GNUC__ && (MX_CPU_powerpc || MX_CPU_powerpc64) && !defined MX_KERNEL

#if MX_ENABLE_ALTIVEC
#define MX_COPY_WITH_ALTIVEC 1
#else
#define MX_COPY_WITH_PPC_ASM 1
#endif

/* Workaround MacOS non-GNU assembly */
#if MX_OS_MACOSX
#define LFD "lfd        f"
#define STFD "stfd      f"
#define LVX "lvx        v"
#define STVX "stvx      v"
#else
#define LFD "lfd        "
#define STFD "stfd      "
#define LVX "lvx        "
#define STVX "stvx      "
#endif

#endif

/************
 * defaults *
 ************/
#ifndef MX_COPY_WITH_SSE2
#define MX_COPY_WITH_SSE2 0
#endif
#ifndef MX_COPY_WITH_ALTIVEC
#define MX_COPY_WITH_ALTIVEC 0
#endif
#ifndef MX_COPY_WITH_PPC_ASM
#define MX_COPY_WITH_PPC_ASM 0
#endif

#endif /* __MX_CPU__ */
